<?php

namespace App\Http\Controllers\Api;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;

class SponsorsExhibitorsApiController extends Controller
{
    public function show($id)
    {
        $conference = DB::table('conferences')->select('unique_id')->find($id);
        if (!$conference) {
            return response()->json(['success' => false, 'message' => 'Conference not found'], 404);
        }

        $uploadsBase = "https://scisynopsisconferences.com/uploads/conferences";

        // Sponsors & Exhibitors Content (Top Section)
        $cmsInfo = DB::table('c_sponsors_content')
            ->where(['conference_id' => $id])
            ->orderBy('id', 'ASC')
            ->get()
            ->map(function ($item) use ($uploadsBase, $conference) {
                $item->image_url = $item->cms_img
                    ? "{$uploadsBase}/{$conference->unique_id}/" . urlencode($item->cms_img)
                    : null;
                return $item;
            });

        // Exhibitors Packages
        $exhibitorsContent = DB::table('c_exhibitors_content')
            ->where(['conference_id' => $id])
            ->orderBy('id', 'ASC')
            ->get()
            ->map(function ($pkg) use ($uploadsBase, $conference) {
                // Exhibitor data (tabs)
                $exhibitorsData = DB::table('c_exhibitors_data')
                    ->where(['c_exhibitors_content_id' => $pkg->id])
                    ->orderBy('id', 'ASC')
                    ->get();

                $pkg->exhibitorsData = $exhibitorsData;
                $pkg->pdf_url = $pkg->cms_img
                    ? "{$uploadsBase}/{$conference->unique_id}/" . urlencode($pkg->cms_img)
                    : null;

                return $pkg;
            });

        // Sponsors (Official Sponsors)
        $sponsors = DB::table('c_sponsors')
            ->where([
                'conference_id' => $id,
                'page_type' => 1,
                'status' => 1
            ])
            ->orderBy('id', 'ASC')
            ->get()
            ->map(function ($s) use ($uploadsBase, $conference) {
                $s->logo_url = $s->logo
                    ? "{$uploadsBase}/{$conference->unique_id}/" . urlencode($s->logo)
                    : null;
                $s->profile_url = "/exhibitors-sponsors/{$s->alias_title}";
                return $s;
            });

        // Meta
        $metaRecord = DB::table('c_meta_data')
            ->where(['conference_id' => $id, 'page_type' => 12])
            ->first();

        return response()->json([
            'success' => true,
            'sponsorsExhibitorsData' => compact('cmsInfo', 'exhibitorsContent', 'sponsors'),
            'meta' => [
                'title' => $metaRecord->meta_title ?? 'Sponsors & Exhibitors – Conference',
                'description' => $metaRecord->meta_description ?? 'Our sponsors and exhibitors who support the conference.',
                'keywords' => $metaRecord->meta_keywords ?? 'sponsors, exhibitors, partnerships, conference'
            ]
        ]);
    }
}