<?php
// app/Http/Controllers/Api/SpeakersListApiController.php
namespace App\Http\Controllers\Api;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;

class SpeakersListApiController extends Controller
{
    public function show($id)
    {
        $speaker_type = request('speaker_type', '2');

        if ($speaker_type === '5') {
            $page_type = 6;
            $clmName = 'E-Poster Presentation';
            $clmName1 = 'E-Poster';
            $clmName2 = 'Presentation';
            $cntlrname = 'e-poster-presentation';
        } elseif ($speaker_type === '2') {
            $page_type = 7;
            $clmName = 'Keynote Speakers';
            $clmName1 = 'Keynote';
            $clmName2 = 'Speakers';
            $cntlrname = 'keynote-speakers';
        } elseif ($speaker_type === '3') {
            $page_type = 15;
            $clmName = 'Renowned Speakers';
            $clmName1 = 'Renowned';
            $clmName2 = 'Speakers';
            $cntlrname = 'renowned-speakers';
        } else {
            $page_type = 9;
            $clmName = 'Poster Presentation';
            $clmName1 = 'Poster';
            $clmName2 = 'Presentation';
            $cntlrname = 'poster-presentation';
        }

        $conference = DB::table('conferences')->where('id',$id)->first();

        $banners = DB::table('c_banners')
            ->where(['status'=>1,'conference_id'=>$id,'page_type'=>$page_type])
            ->orderByDesc('id')->get();

        $metaRow = DB::table('c_meta_data')
            ->where(['conference_id'=>$id,'page_type'=>$page_type])
            ->orderByDesc('id')->first();

        $speakers = DB::table('c_speakers as s')
            ->leftJoin('countries as c', function($j){ $j->on('c.id','=','s.country_id')->where('c.status',1); })
            ->select([
                's.id','s.alias_name','s.speaker_img','s.speaker_name',
                's.speaker_title','s.affliation','s.speaker_type',
                DB::raw('COALESCE(c.country_name, "") as country_name')
            ])
            ->where(['s.conference_id'=>$id,'s.speaker_type'=>$speaker_type])
            ->orderBy('s.orderpos','ASC')->get();

        $cmsInfo = $speakers->map(function($s){
            return [
                'id'=>$s->id,
                'alias_name'=>$s->alias_name,
                'speaker_img'=>$s->speaker_img,
                'speaker_name'=>$s->speaker_name,
                'speaker_title'=>$s->speaker_title,
                'affliation'=>$s->affliation,
                'speaker_type'=>$s->speaker_type,
                'countryInfo'=>$s->country_name ? [ ['country_name'=>$s->country_name] ] : []
            ];
        })->values();

        return response()->json([
            'success'=>true,
            'cntlrname'=>$cntlrname,
            'clmName'=>$clmName,
            'clmName1'=>$clmName1,
            'clmName2'=>$clmName2,
            'speaker_type'=>$speaker_type,
            'cmsInfo'=>$cmsInfo,
            'banners'=>$banners,
            'meta'=>[
                'title'=>$metaRow->meta_title ?? $clmName.' – Conference',
                'description'=>$metaRow->meta_description ?? $clmName,
                'keywords'=>$metaRow->meta_keywords ?? $clmName
            ],
            'conferenceInfo'=>$conference ? [ $conference ] : []
        ]);
    }
}
