<?php

namespace App\Http\Controllers\Api;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;

class SpeakerDetailsApiController extends Controller
{
    public function show($id, $alias_name)
    {

        // Get speaker type from query param or default
        $speaker_type = request('speaker_type', 6); // 6 = Eminent, 2 = Keynote, 1 = Scientific

        $speaker = DB::table('c_speakers')
            ->where([
                'conference_id' => $id,
                'alias_name' => $alias_name,
                'speaker_type' => $speaker_type,
                'status' => 1
            ])
            ->first();

        if (!$speaker) {
            return response()->json(['error' => 'Speaker not found'], 404);
        }

        // Get country
        $country = DB::table('countries')
            ->where('id', $speaker->country_id)
            ->where('status', 1)
            ->first();

        // Format speaker data
        $speakerData = [
            'id' => $speaker->id,
            'speaker_img' => $speaker->speaker_img,
            'alias_name' => $speaker->alias_name,
            'speaker_name' => $speaker->speaker_name,
            'speaker_title' => $speaker->speaker_title,
            'affliation' => $speaker->affliation,
            'biography' => $speaker->biography,
            'researchIntrest' => $speaker->researchIntrest,
            'acceptance_letter' => $speaker->acceptance_letter,
            'countryInfo' => $country ? ['country_name' => $country->country_name] : null,
        ];

        // Determine title and breadcrumbs
       // Determine title and breadcrumbs
switch ($speaker_type) {
    case 1:
        $speakerTitle = 'Scientific Committee';
        break;
    case 2:
        $speakerTitle = 'Keynote Speaker';
        break;
    case 6:
        $speakerTitle = 'Eminent Speaker';
        break;
    default:
        $speakerTitle = 'Speaker';
        break;
}

switch ($speaker_type) {
    case 1:
        $pageUrl = 'scientific-committee';
        break;
    case 2:
        $pageUrl = 'keynote-speakers';
        break;
    case 6:
        $pageUrl = 'eminent-speakers';
        break;
    default:
        $pageUrl = 'all-speakers';
        break;
}




        return response()->json([
            'success' => true,
            'speakerDetailsData' => $speakerData,
            'speakerTitle' => $speakerTitle,
            'pageUrl' => $pageUrl,
            'meta' => [
                'title' => "{$speaker->speaker_name} – {$speakerTitle}",
                'description' => "Profile of {$speaker->speaker_name}, {$speaker->speaker_title} at the conference.",
                'keywords' => "{$speaker->speaker_name}, {$speakerTitle}, {$speaker->affliation}"
            ]
        ]);
    }
}