<?php

namespace App\Http\Controllers\Api;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class PresentationSubmissionApiController extends Controller
{
    public function show($id)
    {
        $conference = DB::table('conferences')->find($id);
        if (!$conference) {
            return response()->json(['success' => false, 'message' => 'Conference not found'], 404);
        }

        $uploadsBase = "https://scisynopsisconferences.com/uploads/conferences";

        // Sample abstract (page_type = 2)
        $sampleAbstract = DB::table('c_brouchers')
            ->where([
                'conference_id' => $id,
                'page_type' => 2,
                'status' => 1
            ])
            ->first();

        $sampleUrl = $sampleAbstract?->brouchure_name
            ? "{$uploadsBase}/{$conference->unique_id}/" . urlencode($sampleAbstract->brouchure_name)
            : null;

        // Abstract content (page_type = 5)
        $abstractContent = DB::table('c_abstract_content')
            ->where([
                'conference_id' => $id,
                'page_type' => 5,
                'status' => 1
            ])
            ->orderBy('id', 'ASC')
            ->get();

        // Other data
        $abstractCategories = DB::table('abstract_categories')->where('status', 1)->get();
        $sessionTracks = DB::table('c_session_tracks')->where(['conference_id' => $id, 'status' => 1])->orderBy('orderpos', 'ASC')->get();
        $countriesList = DB::table('countries')->where('status', 1)->orderBy('country_name', 'ASC')->get();

        // Meta
        $metaRecord = DB::table('c_meta_data')
            ->where(['conference_id' => $id, 'page_type' => 14])
            ->first();

        return response()->json([
            'success' => true,
            'presentationData' => compact('sampleAbstract', 'sampleUrl', 'abstractContent', 'abstractCategories', 'sessionTracks', 'countriesList'),
            'meta' => [
                'title' => $metaRecord->meta_title ?? 'Presentation Submission – Conference',
                'description' => 'Submit your presentation for the conference.',
                'keywords' => 'presentation, submission, abstract, conference'
            ]
        ]);
    }

    public function submit(Request $request)
    {
       
$id = $request['conference_id'];
        $conference = DB::table('conferences')->find($id);

        // Store file
        $file = request()->file('user_file');
        $filename = 'presentation_' . time() . '.' . $file->getClientOriginalExtension();
        $path = "uploads/conferences/{$conference->unique_id}_{$id}/";
        $file->move(public_path($path), $filename);

        // Insert into c_reg_users
        $insertId = DB::table('c_reg_users')->insertGetId([
            'unique_id' => now()->format('smdiYH'),
            'conference_id' => $id,
            'designation' => $request['designation'],
            'firstname' => $request['firstname'],
            'lastname' => '',
            'usr_email' => $request['usr_email'],
            'user_phone' => $request['user_phone'],
            'user_file' => $filename,
            'queries' => $request['abstract_message'] ?? '',
            'created_date' => now(),
            'user_type' => 5,
            'absCategory' => $request['abstractcategory'] ?? null,
            'sessions_id' => $request['session_id'] ?? null,
        ]);

        if ($insertId) {
            return response()->json([
                'success' => true,
                'message' => 'Thank you submitting Presentation. We will get back to you soon.'
            ]);
        }

        return response()->json([
            'success' => false,
            'error' => 'Failed to submit your details. Please try again.'
        ]);
    }
}