<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class OnlinePaypalApiController extends Controller
{
    /**
     * PayPal return redirect (user is sent here after payment)
     */
    public function returnFromPayPal(Request $request)
    {
        $orderId = $request->get('order_id');

        if (!$orderId) {
            return redirect('/online-registration?error=missing_order');
        }

        // mark as paid (basic example)
        DB::table('c_user_registrations_dates')
            ->where('order_id', $orderId)
            ->update(['payment_status' => 'paid']);

        return redirect("/online-payment-success/$orderId");
    }

    /**
     * PayPal IPN (Instant Payment Notification)
     * PayPal server calls this silently
     */
    public function handleIPN(Request $request)
    {
        $data = $request->all();
        Log::info('PayPal IPN received', $data);

        if (!empty($data['invoice'])) {
            DB::table('c_user_registrations_dates')
                ->where('order_id', $data['invoice'])
                ->update(['payment_status' => 'paid']);
        }

        return response('OK', 200);
    }

    /**
     * Fetch success data (used by Vue success page)
     */
    public function getSuccessData($orderId)
    {
        $order = DB::table('c_user_registrations_dates')->where('order_id', $orderId)->first();
        if (!$order) {
            return response()->json(['success' => false, 'message' => 'Order not found']);
        }

        $user = DB::table('c_reg_users')->where('id', $order->user_id)->first();

        return response()->json([
            'success' => true,
            'data' => [
                'order_id' => $order->order_id,
                'total_amount' => $order->total_amount,
                'currency' => $order->curency_type,
                'payment_meathod' => $order->payment_meathod,
                'usr_email' => $user->usr_email ?? '',
                'user_phone' => $user->user_phone ?? '',
                'created_date' => $order->created_date
            ]
        ]);
    }
}
