<?php
namespace App\Http\Controllers\Api;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Carbon\Carbon;
use Carbon\CarbonPeriod;

class HomepageApiController extends Controller
{
    public function index($id)
    {
        $conferenceInfo = DB::table('conferences')->where('id', $id)->first();

        $banners = DB::table('c_banners')
            ->where(['status' => 1, 'page_type' => 1, 'conference_id' => $id])
            ->get();

        $aboutus = DB::table('c_aboutus')
            ->where(['status' => 1, 'conference_id' => $id])
            ->get();

        $quickLinks = DB::table('c_quick_links')
            ->where(['status' => 1, 'conference_id' => $id])
            ->orderBy('order_position', 'ASC')
            ->get();

        $homeprevGallery = DB::table('c_home_past_gallery')
            ->where(['status' => 1, 'conference_id' => $id, 'page_type' => 1])
            ->limit(4)
            ->get();
        $sessionTracks =  DB::table('c_session_tracks')
            ->where(['status' => 1, 'conference_id' => $id, 'parent_id' => 0])
            ->orderBy('orderpos', 'ASC')
            ->get();
        
        $impDates = DB::table('c_imp_dates')
            ->where(['status' => 1, 'conference_id' => $id])
            ->orderBy('id', 'ASC')
            ->get();
         // ----- Scientific Committee (OCM Speakers) -----
        $ocmSpeakersRaw = DB::table('c_speakers as s')
            ->leftJoin('countries as co', 'co.id', '=', 's.country_id')
            ->leftJoin('cities as ci', 'ci.id', '=', 's.city_id')
            ->where([
                's.status'        => 1,
                's.conference_id' => $id,
                's.speaker_type'  => 1, // OCM / Scientific Committee
            ])
            ->orderBy('s.orderpos', 'ASC')
            ->limit(4)
            ->get([
                's.id',
                's.speaker_name',
                's.speaker_title',
                's.alias_name',
                's.affliation',
                's.speaker_img',
                's.country_id',
                'co.country_name',
                'ci.city_name',
            ]);

        // Shape to match frontend expectations: countryInfo[0]?.country_name, cityInfo[0]?.city_name
        $ocmSpeakers = $ocmSpeakersRaw->map(function ($r) {
            return [
                'id'            => $r->id,
                'speaker_name'  => $r->speaker_name,
                'speaker_title' => $r->speaker_title,
                'alias_name'    => $r->alias_name,
                'affliation'    => $r->affliation,
                'speaker_img'   => $r->speaker_img,
                'country_id'    => $r->country_id,
                'countryInfo'   => $r->country_name ? [['country_name' => $r->country_name]] : [],
                'cityInfo'      => $r->city_name ? [['city_name' => $r->city_name]] : [],
            ];
        })->values();
        // -----------------------------------------------


/* ---------- Previous Speakers (prevArray) using mainsiteDb for lookups ---------- */

// 1) All "previous conference" mappings for this conference (default connection)
$previousSpk = DB::table('c_previous_speakers')
    ->where('conference_id', $id)
    ->orderBy('orderpos', 'ASC')
    ->get();

$prevArray = [];
$other = DB::connection('mainsiteDb'); // <-- other database

foreach ($previousSpk as $row) {
    // 2) Previous conference basic info (as an array with one element, to match [0] access in Vue)
    $prevConfInfo = DB::table('conferences')
        ->where('id', $row->previous_conference_id)
        ->get(['id','unique_id','conference_url']); // keep as Collection so [0] works in Vue

    // 3) Up to 4 previous speakers from that previous conference (speaker_type = 6) - default DB
    $speakers = DB::table('c_speakers')
        ->where([
            'status'        => 1,
            'conference_id' => $row->previous_conference_id,
            'speaker_type'  => 6,
        ])
        ->orderBy('orderpos', 'ASC')
        ->limit(4)
        ->get([
            'id','conference_id','speaker_title','speaker_name','alias_name','speaker_img',
            'affliation','continent_id','country_id','city_id','hospital_id','university_id'
        ]);

    // If no speakers, push the shell and continue
    if ($speakers->isEmpty()) {
        $prevArray[] = [
            'id'                     => $row->id,
            'conference_id'          => $row->conference_id,
            'previous_conference_id' => $row->previous_conference_id,
            'orderpos'               => $row->orderpos,
            'status'                 => $row->status,
            'prevConfInfo'           => $prevConfInfo,
            'speakersInfo'           => collect(), // empty
        ];
        continue;
    }

    // ---- Batch IDs for lookups from mainsiteDb (avoid N+1) ----
    $continentIds = $speakers->pluck('continent_id')->filter()->unique()->values();
    $countryIds   = $speakers->pluck('country_id')->filter()->unique()->values();
    $cityIds      = $speakers->pluck('city_id')->filter()->unique()->values();
    $uniIds       = $speakers->pluck('university_id')->filter()->unique()->values();
    $hospIds      = $speakers->pluck('hospital_id')->filter()->unique()->values();

    // Fetch maps from mainsiteDb
    $continentsMap = $continentIds->isEmpty()
        ? collect()
        : $other->table('continents')
            ->where('status', 1)
            ->whereIn('id', $continentIds)
            ->get(['id','continent_name'])
            ->keyBy('id');

    $countriesMap = $countryIds->isEmpty()
        ? collect()
        : $other->table('countries')
            ->where('status', 1)
            ->whereIn('id', $countryIds)
            ->get(['id','country_name'])
            ->keyBy('id');

    $citiesMap = $cityIds->isEmpty()
        ? collect()
        : $other->table('cities')
            ->where('status', 1)
            ->whereIn('id', $cityIds)
            ->get(['id','city_name'])
            ->keyBy('id');

    $universitiesMap = $uniIds->isEmpty()
        ? collect()
        : $other->table('hospital_universities')
            ->where('status', 1)
            ->whereIn('id', $uniIds)
            ->get(['id','name'])
            ->keyBy('id');

    $hospitalsMap = $hospIds->isEmpty()
        ? collect()
        : $other->table('hospital_universities')
            ->where('status', 1)
            ->whereIn('id', $hospIds)
            ->get(['id','name'])
            ->keyBy('id');

    // 4) Shape speaker data to match your existing front-end expectations
    $speakersInfo = $speakers->map(function ($s) use ($continentsMap, $countriesMap, $citiesMap, $universitiesMap, $hospitalsMap) {
        $continent = $s->continent_id && $continentsMap->has($s->continent_id) ? $continentsMap[$s->continent_id] : null;
        $country   = $s->country_id   && $countriesMap->has($s->country_id)   ? $countriesMap[$s->country_id]   : null;
        $city      = $s->city_id      && $citiesMap->has($s->city_id)         ? $citiesMap[$s->city_id]         : null;
        $univ      = $s->university_id&& $universitiesMap->has($s->university_id)? $universitiesMap[$s->university_id] : null;
        $hosp      = $s->hospital_id  && $hospitalsMap->has($s->hospital_id)  ? $hospitalsMap[$s->hospital_id]  : null;

        return [
            'id'             => $s->id,
            'conference_id'  => $s->conference_id,
            'speaker_title'  => $s->speaker_title,
            'speaker_name'   => $s->speaker_name,
            'alias_name'     => $s->alias_name,
            'speaker_img'    => $s->speaker_img,
            'affliation'     => $s->affliation,
            'continent_id'   => $s->continent_id,
            'country_id'     => $s->country_id,
            'city_id'        => $s->city_id,
            'hospital_id'    => $s->hospital_id,
            'university_id'  => $s->university_id,

            // Keep these as arrays so Vue can safely do [0]? access
            'continentsInfo' => $continent ? [['id' => $continent->id, 'continent_name' => $continent->continent_name]] : [],
            'countryInfo'    => $country   ? [['id' => $country->id,   'country_name'   => $country->country_name]]   : [],
            'cityInfo'       => $city      ? [['id' => $city->id,      'city_name'      => $city->city_name]]         : [],
            'universityInfo' => $univ      ? [['id' => $univ->id,      'name'           => $univ->name]]               : [],
            'hospitalInfo'   => $hosp      ? [['id' => $hosp->id,      'name'           => $hosp->name]]               : [],
        ];
    })->values();

    $prevArray[] = [
        'id'                     => $row->id,
        'conference_id'          => $row->conference_id,
        'previous_conference_id' => $row->previous_conference_id,
        'orderpos'               => $row->orderpos,
        'status'                 => $row->status,
        // keep as array to support prevConfInfo[0] on the Vue side
        'prevConfInfo'           => $prevConfInfo,
        'speakersInfo'           => $speakersInfo,
    ];
}
/* ----------------------------------------------------------------------------- */



/* ---------- Keynote Speakers (speaker_type = 2) ---------- */

// 1) Pull keynote speakers from default DB
$keynoteSpeakers = DB::table('c_speakers')
    ->where([
        'status'        => 1,
        'conference_id' => $id,          // or $conferenceId if that’s your var
        'speaker_type'  => 2,            // Keynote
    ])
    ->orderBy('orderpos', 'ASC')
    ->limit(4)
    ->get([
        'id','speaker_name','speaker_title','alias_name','affliation',
        'speaker_img','country_id','city_id'
    ]);

$keynoteArray = [];
if ($keynoteSpeakers->isNotEmpty()) {
    // 2) Batch IDs for cross-DB lookups
    $countryIds = $keynoteSpeakers->pluck('country_id')->filter()->unique()->values();
    $cityIds    = $keynoteSpeakers->pluck('city_id')->filter()->unique()->values();

    // 3) Fetch from mainsiteDb in one shot
    $other = DB::connection('mainsiteDb');

    $countriesMap = $countryIds->isEmpty()
        ? collect()
        : $other->table('countries')
            ->where('status', 1)
            ->whereIn('id', $countryIds)
            ->get(['id','country_name'])
            ->keyBy('id');

    $citiesMap = $cityIds->isEmpty()
        ? collect()
        : $other->table('cities')
            ->where('status', 1)
            ->whereIn('id', $cityIds)
            ->get(['id','city_name'])
            ->keyBy('id');

    // 4) Shape result like your original array
    $keynoteArray = $keynoteSpeakers->map(function ($s) use ($countriesMap, $citiesMap) {
        $country = $s->country_id && $countriesMap->has($s->country_id) ? $countriesMap[$s->country_id] : null;
        $city    = $s->city_id    && $citiesMap->has($s->city_id)       ? $citiesMap[$s->city_id]       : null;

        return [
            'id'            => $s->id,
            'speaker_name'  => $s->speaker_name,
            'speaker_title' => $s->speaker_title,
            'alias_name'    => $s->alias_name,
            'affliation'    => $s->affliation,
            'speaker_img'   => $s->speaker_img,
            'country_id'    => $s->country_id,

            // Keep array wrappers so Vue can safely do [0]? access
            'countryInfo'   => $country ? [['country_name' => $country->country_name]] : [],
            'cityInfo'      => $city    ? [['city_name'    => $city->city_name]]       : [],
        ];
    })->values()->all();
}


/* ---------- Eminent Speakers (speaker_type = 6) ---------- */

// 1) Pull eminent speakers from default DB
$eminentSpeakers = DB::table('c_speakers')
    ->where([
        'status'        => 1,
        'conference_id' => $id,   // use $conferenceId if that's your variable name
        'speaker_type'  => 6,     // Eminent
    ])
    ->orderBy('orderpos', 'ASC')
    ->limit(4)
    ->get([
        'id','speaker_name','speaker_title','alias_name','affliation',
        'speaker_img','country_id','city_id'
    ]);

$eminentArray = [];
if ($eminentSpeakers->isNotEmpty()) {
    // 2) Batch IDs for cross-DB lookups
    $countryIds = $eminentSpeakers->pluck('country_id')->filter()->unique()->values();
    $cityIds    = $eminentSpeakers->pluck('city_id')->filter()->unique()->values();

    // 3) Fetch from mainsiteDb in one shot
    $other = DB::connection('mainsiteDb');

    $countriesMap = $countryIds->isEmpty()
        ? collect()
        : $other->table('countries')
            ->where('status', 1)
            ->whereIn('id', $countryIds)
            ->get(['id','country_name'])
            ->keyBy('id');

    $citiesMap = $cityIds->isEmpty()
        ? collect()
        : $other->table('cities')
            ->where('status', 1)
            ->whereIn('id', $cityIds)
            ->get(['id','city_name'])
            ->keyBy('id');

    // 4) Shape result like your original array
    $eminentArray = $eminentSpeakers->map(function ($s) use ($countriesMap, $citiesMap) {
        $country = $s->country_id && $countriesMap->has($s->country_id) ? $countriesMap[$s->country_id] : null;
        $city    = $s->city_id    && $citiesMap->has($s->city_id)       ? $citiesMap[$s->city_id]       : null;

        return [
            'id'            => $s->id,
            'speaker_name'  => $s->speaker_name,
            'speaker_title' => $s->speaker_title,
            'alias_name'    => $s->alias_name,
            'affliation'    => $s->affliation,
            'speaker_img'   => $s->speaker_img,
            'country_id'    => $s->country_id,

            // Keep array wrappers so Vue can safely do countryInfo[0]?.country_name, etc.
            'countryInfo'   => $country ? [['country_name' => $country->country_name]] : [],
            'cityInfo'      => $city    ? [['city_name'    => $city->city_name]]       : [],
        ];
    })->values()->all();
}



$supportJournals =  DB::table('c_support_journals')
            ->where(['status' => 1, 'conference_id' => $id])
                        ->orderBy('order_position', 'ASC')

            ->get();
            
 			$earlyBird =  DB::table('c_earlybird')
            ->where(['status' => 1, 'conference_id' => $id])
                        ->orderBy('id', 'DESC')

            ->get();
           
            
   $workshops =  DB::table('postconferenceworkshops')
            ->where(['conference_id' => $id])
            ->orderBy('id', 'DESC')
            ->get();
           
$venueInfo = DB::table('c_venue')
            ->where(['status' => 1,'conference_id' => $id])
            ->orderBy('id', 'DESC')
            ->get();
			$globaltarget = DB::table('c_globaltarget')
            ->where(['status' => 1,'conference_id' => $id])
            ->orderBy('id', 'DESC')
            ->get();
         
         
        /* ---------- Skeleton Schedule ---------- */

// 1) Get from/to dates for the conference
$conf = DB::table('conferences')
    ->where('id', $id) // or $conferenceId
    ->first(['from_date','to_date']);

$skeletonschedule = collect();

if ($conf && !empty($conf->from_date) && !empty($conf->to_date)) {
    // 2) Build list of days (inclusive)
    $format = 'Y-m-d';
    $period = CarbonPeriod::create(
        Carbon::parse($conf->from_date)->startOfDay(),
        Carbon::parse($conf->to_date)->startOfDay()
    );

    $schDays = collect();
    foreach ($period as $date) {
        $schDays->push($date->format($format));
    }

    // 3) For each day, fetch sessions from c_skeleton_schedule
    $skeletonschedule = $schDays->values()->map(function ($schDate, $idx) use ($id) {
        $dayIndex = $idx + 1;

        $speakersInfo = DB::table('c_skeleton_schedule')
            ->where([
                'status'        => 1,
                'conference_id' => $id,
                'sch_day'       => $dayIndex,
            ])
            ->orderBy('id', 'ASC')
            ->get([
                // include all columns you need in Vue:
                'id',
                'sch_from_time',
                'sch_to_time',
                'content_title',
                'content_desc',
                // 'speaker_id', 'room', ... (if any)
            ]);

        return [
            'day'          => 'Day-' . $dayIndex,
            'schDate'      => $schDate,
            'schId'        => $idx,
            'speakersInfo' => $speakersInfo,
        ];
    });
}

// OPTIONAL: schedule content line under the heading
// Adjust the table name/columns to your schema (example below).
$schedulecontent = DB::table('c_skeleton_schedule_content') // <- change if different
    ->where(['status' => 1, 'conference_id' => $id])
    ->orderBy('id', 'ASC')
    ->limit(1)
    ->get(['content']);

         
         /* ---------- Past Conference Reports ---------- */

// 1) Collect all past conference IDs mapped to this conference
$pastConfIds = DB::table('c_past_conferences')
    ->where(['status' => 1, 'conference_id' => $id])   // or $conferenceId
    ->orderBy('id', 'ASC')
    ->pluck('past_conference_id')
    ->filter()                  // drop null/empty
    ->unique()
    ->values();

// 2) Fetch all reports for those past conferences in one go
$pastReportsRaw = $pastConfIds->isEmpty()
    ? collect()
    : DB::table('c_past_conference_report')
        ->where('status', 1)
        ->whereIn('conference_id', $pastConfIds)
        ->orderBy('id', 'ASC')
        ->get([
            'id',
            'conference_id',
            'conf_title',
            'conf_desc',
            // add other fields if your Vue needs them
        ]);

// 3) Group by conference_id, and shape as an array-of-arrays
$reportsByConf = $pastReportsRaw->groupBy('conference_id');

$pastConferenceReport = [];
foreach ($pastConfIds as $confId) {
    $reports = $reportsByConf->get($confId, collect());
    if ($reports->isNotEmpty()) {
        // Keep as an array so Vue can do report[0].*
        $pastConferenceReport[] = $reports->values();
    }
}


            
            
            /* ---------- Welcome Message ---------- */
$welcomeMessage = DB::table('c_welcome_message')
    ->where(['status' => 1, 'conference_id' => $id])
    ->orderBy('id', 'ASC')
    ->get(['id','name','affiliation','welcome_img','welcome_desc']);

/* ---------- Exhibitors / Sponsorships ---------- */
$sponsors = DB::table('c_sponsors')
    ->where(['status' => 1, 'conference_id' => $id, 'page_type' => 1])
    ->orderBy('id', 'ASC')
    ->get(['id','alias_title','logo']);

/* ---------- Media Partners / Collaboration ---------- */
$mediaPartners = DB::table('c_sponsors')
    ->where(['status' => 1, 'conference_id' => $id, 'page_type' => 2])
    ->orderBy('id', 'ASC')
    ->get(['id','alias_title','logo']);

/* ---------- Testimonials ---------- */
$testimonials = DB::table('testimonials')
    ->where(['conference_id' => $id, 'status' => 1])
    ->orderBy('id', 'DESC')
    ->get(['id','testimonial_title','testimonial_desc','testimonial_image','sub_title']);

/* If you don’t have a separate "testimonialspeakers" table,
   reuse the first testimonial for the left block */
$testimonialspeakers = $testimonials->take(1)->values();

/* ---------- Past Conference Gallery (homeprevArray) ---------- */
/* pick the highlighted past conference from c_home_past_gallery (page_type = 1) */
$homeprevGallery = DB::table('c_home_past_gallery')
    ->where(['status' => 1, 'conference_id' => $id, 'page_type' => 1])
    ->orderBy('id', 'ASC')
    ->get(['id','past_conference_id']);

$homeprevArray = collect();
$pastvideosInfoname = collect(); // for /past-reports/${homepageData.pastvideosInfoname[0]?.short_alias_name}

if ($homeprevGallery->isNotEmpty()) {
    $targetPastConfId = $homeprevGallery[0]->past_conference_id;

    // gallery items for that past conference (exclude parent rows)
    $homeprevArray = DB::table('previous_conference_gallery')
        ->where('status', 1)
        ->where('conference_id', $targetPastConfId)
        ->where('parent_id', '<>', 0)
        ->orderBy('id', 'ASC')
        ->limit(8)
        ->get(['id','gallery_img','gallery_title']);

    // Used by “Past Conference Videos” VIEW ALL link
    $pastvideosInfoname = DB::table('conferences')
        ->where(['status' => 1, 'id' => $targetPastConfId])
        ->limit(1)
        ->get(['id','short_alias_name']);
}

/* ---------- Our Past Events (homeprevAllArray) ---------- */
/* list up to 4 past conferences to show a teaser image + link */
$homePrevAllGalleryonlyfour = DB::table('c_home_past_gallery')
    ->where(['status' => 1, 'conference_id' => $id, 'page_type' => 2])
    ->orderBy('id', 'DESC')
    ->limit(4)
    ->get(['id','past_conference_id']);

$homeprevAllArrayonlyfour = [];
foreach ($homePrevAllGalleryonlyfour as $hp) {
    $conference = DB::table('conferences')
        ->where('id', $hp->past_conference_id)
        ->first(['id','short_alias_name']);

    // single teaser image (your Vue uses item.gallery[0]?.gallery_img)
    $gallery = DB::table('previous_conference_gallery')
        ->where(['status' => 1, 'conference_id' => $hp->past_conference_id])
        ->orderBy('id', 'ASC')
        ->limit(1)
        ->get(['gallery_img','gallery_title']);

    $homeprevAllArrayonlyfour[] = [
        'conference' => $conference,  // object
        'gallery'    => $gallery,     // array (collection)
    ];
}

/* ---------- Past Conference Videos ---------- */
$conferenceVideos = DB::table('previous_conference_videos')
    ->where(['status' => 1, 'parent_id' => $id])
    ->limit(3)
    ->get(['id','video_url','video_title']);

            
            
            
            
            
        $homeprevAllArray = [];
        foreach ($homeprevGallery as $item) {
            $conf = DB::table('conferences')->where('id', $item->past_conference_id)->first();
            $gallery = DB::table('c_home_past_gallery')->where('conference_id', $item->past_conference_id)->limit(4)->get();
            $homeprevAllArray[] = [
                'conference' => $conf,
                'gallery' => $gallery
            ];
        }

        $conferenceVideos = DB::table('previous_conference_videos')
            ->where(['status' => 1, 'parent_id' => $id])
            ->limit(3)
            ->get();

        return response()->json([
            'success' => true,
            'homepageData' => [
                'banners' => $banners,
                'aboutus' => $aboutus,
                'quickLinks' => $quickLinks,
                'sessionTracks' => $sessionTracks,
                'impDates' => $impDates,
                'keynoteSpeakers' => $keynoteArray,
                'prevArray'        => $prevArray,
                 'ocmSpeakers'       => $ocmSpeakers,
                 'eminentSpeakers' => $eminentArray,
                 'earlyBird' => $earlyBird,
                 'workshops' => $workshops,
                 'supportJournals' => $supportJournals,
                'venueInfo' => $venueInfo,
                'globaltarget' => $globaltarget,
                'skeletonschedule' => $skeletonschedule->values(),
                'schedulecontent'  => $schedulecontent,
                'homeprevAllArray' => $homeprevAllArray,
                
                
                'welcomeMessage'       => $welcomeMessage,
        'sponsors'             => $sponsors,
        'mediaPartners'        => $mediaPartners,
        'testimonials'         => $testimonials,
        'testimonialspeakers'  => $testimonialspeakers,

        'homeprevArray'        => $homeprevArray,
        'homeprevAllArrayonlyfour'     => $homeprevAllArrayonlyfour,
        'conferenceVideos'     => $conferenceVideos,
        'pastvideosInfoname'   => $pastvideosInfoname,
                
                
                  'pastconferencerepports' => $pastConferenceReport,
                'conferenceVideos' => $conferenceVideos
            ]
        ]);
    }
    
 public function indexv1($id)
{
    // Conference Info
    $conferenceInfo = DB::table('conferences')->where('id', $id)->first();

    // Banners
    $banners = DB::table('c_banners')
        ->where(['status' => 1, 'page_type' => 1, 'conference_id' => $id])
        ->get();

    // Session Tracks
    $sessionTracks = DB::table('c_session_tracks')
        ->where(['status' => 1, 'conference_id' => $id, 'parent_id' => 0])
        ->orderBy('orderpos', 'ASC')
        ->get();

    // Important Dates
    $impDates = DB::table('c_imp_dates')
        ->where(['status' => 1, 'conference_id' => $id])
        ->orderBy('id', 'ASC')
        ->get();

    // About Us
    $aboutus = DB::table('c_aboutus')
        ->where(['status' => 1, 'conference_id' => $id])
        ->get();

    // Welcome Message
    $welcomeMessage = DB::table('c_welcome_message')
        ->where(['status' => 1, 'conference_id' => $id])
        ->orderBy('id', 'ASC')
        ->get(['id', 'name', 'affiliation', 'welcome_img', 'welcome_desc']);
 $quickLinks = DB::table('c_quick_links')
            ->where(['status' => 1, 'conference_id' => $id])
            ->orderBy('order_position', 'ASC')
            ->get();
    // Scientific Committee (OCM Speakers) - limit 4
    $ocmSpeakersRaw = DB::table('c_speakers as s')
        ->leftJoin('countries as co', 'co.id', '=', 's.country_id')
        ->leftJoin('cities as ci', 'ci.id', '=', 's.city_id')
        ->where([
            's.status' => 1,
            's.conference_id' => $id,
            's.speaker_type' => 1,
        ])
        ->orderBy('s.orderpos', 'ASC')
        ->limit(4)
        ->get([
            's.id', 's.speaker_name', 's.speaker_title', 's.alias_name',
            's.affliation', 's.speaker_img', 's.country_id',
            'co.country_name', 'ci.city_name'
        ]);

    $ocmSpeakers = $ocmSpeakersRaw->map(function ($r) {
        return [
            'id' => $r->id,
            'speaker_name' => $r->speaker_name,
            'speaker_title' => $r->speaker_title,
            'alias_name' => $r->alias_name,
            'affliation' => $r->affliation,
            'speaker_img' => $r->speaker_img,
            'country_id' => $r->country_id,
            'countryInfo' => $r->country_name ? [['country_name' => $r->country_name]] : [],
            'cityInfo' => $r->city_name ? [['city_name' => $r->city_name]] : [],
        ];
    })->values();

    // Eminent Speakers by Category (using categories_new)
    $categoriesResult = DB::table('categories_new')
        ->where(['status' => 1])
        ->orderBy('sort_order', 'ASC')
        ->get(['id', 'category_name']);

    $groupedSpeakers = [];

    foreach ($categoriesResult as $category) {
        $speakersRaw = DB::table('c_speakers as s')
            ->leftJoin('countries as co', 'co.id', '=', 's.country_id')
            ->leftJoin('cities as ci', 'ci.id', '=', 's.city_id')
            ->where([
                's.status' => 1,
                's.conference_id' => $id,
                's.speaker_type' => $category->id  // speaker_type = category id
            ])
            ->orderBy('s.orderpos', 'ASC')
            ->get([
                's.id', 's.speaker_name', 's.speaker_title', 's.alias_name',
                's.affliation', 's.speaker_img', 's.country_id',
                'co.country_name', 'ci.city_name'
            ]);

        $groupedSpeakers[$category->id] = $speakersRaw->map(function ($r) {
            return [
                'id' => $r->id,
                'speaker_name' => $r->speaker_name,
                'speaker_title' => $r->speaker_title,
                'alias_name' => $r->alias_name,
                'affliation' => $r->affliation,
                'speaker_img' => $r->speaker_img,
                'country_id' => $r->country_id,
                'countryInfo' => $r->country_name ? [['country_name' => $r->country_name]] : [],
                'cityInfo' => $r->city_name ? [['city_name' => $r->city_name]] : [],
            ];
        })->values();
    }

    // Sponsors
    $sponsors = DB::table('c_sponsors')
        ->where(['status' => 1, 'conference_id' => $id, 'page_type' => 1])
        ->get(['id', 'alias_title', 'logo']);

    // Media Partners
    $mediaPartners = DB::table('c_sponsors')
        ->where(['status' => 1, 'conference_id' => $id, 'page_type' => 2])
        ->get(['id', 'alias_title', 'logo']);

    // Venue
    $venueInfo = DB::table('c_venue')
        ->where(['status' => 1, 'conference_id' => $id])
        ->get();

    // Global Target Audience
    $globaltarget = DB::table('c_globaltarget')
        ->where(['status' => 1, 'conference_id' => $id])
        ->get();

    // Why Choose Us
    $popcontentInfo = DB::table('c_homepage_content')
        ->where(['status' => 1, 'conference_id' => $id])
        ->get(['cms_description', 'cms_title']);

    // Field Wise Programs
    $fieldwise = DB::table('c_fieldwise')
        ->where('conference_id', $id)
        ->get(['id', 'fieldwise_status']);

    // Past Conference Reports
    $pastConfIds = DB::table('c_past_conferences')
        ->where(['status' => 1, 'conference_id' => $id])
        ->pluck('past_conference_id')
        ->filter();

    $pastConferenceReport = [];
    if ($pastConfIds->isNotEmpty()) {
        $reports = DB::table('c_past_conference_report')
            ->where('status', 1)
            ->whereIn('conference_id', $pastConfIds)
            ->orderBy('id', 'ASC')
            ->get(['id', 'conf_title', 'conf_desc']);

        foreach ($pastConfIds as $confId) {
            $filtered = $reports->where('conference_id', $confId);
            if ($filtered->isNotEmpty()) {
                $pastConferenceReport[] = $filtered->values();
            }
        }
    }

    // Past Conference Gallery
    $homeprevGallery = DB::table('c_home_past_gallery')
        ->where(['status' => 1, 'conference_id' => $id, 'page_type' => 1])
        ->first();

    $homeprevArray = collect();
    if ($homeprevGallery) {
        $homeprevArray = DB::table('previous_conference_gallery')
            ->where([
                'status' => 1,
                'conference_id' => $homeprevGallery->past_conference_id,
                'parent_id' => 0
            ])
            ->orderBy('id', 'ASC')
            ->limit(8)
            ->get(['id', 'gallery_img', 'gallery_title']);
    }

    // Our Past Events (only 4)
    $homePrevAllGalleryonlyfour = DB::table('c_home_past_gallery')
        ->where(['status' => 1, 'conference_id' => $id, 'page_type' => 2])
        ->orderBy('id', 'DESC')
        ->limit(4)
        ->get(['id', 'past_conference_id']);

    $homeprevAllArrayonlyfour = [];
    foreach ($homePrevAllGalleryonlyfour as $item) {
        $conference = DB::table('conferences')
            ->where('id', $item->past_conference_id)
            ->first(['id', 'short_alias_name']);

        $gallery = DB::table('previous_conference_gallery')
            ->where('status', 1)
            ->where('conference_id', $item->past_conference_id)
            ->orderBy('id', 'ASC')
            ->limit(1)
            ->get(['gallery_img', 'gallery_title']);

        $homeprevAllArrayonlyfour[] = [
            'conference' => $conference,
            'gallery' => $gallery
        ];
    }

    // Conference Videos
    $conferenceVideos = DB::table('previous_conference_videos')
        ->where(['status' => 1, 'parent_id' => $id])
        ->limit(3)
        ->get(['id', 'video_url', 'video_title']);

    $pastvideosInfoname = collect();
    if ($conferenceVideos->isNotEmpty()) {
         $confId = $conferenceVideos[0]->conference_id ?? null;
        $pastvideosInfoname = DB::table('conferences')
            ->where('id', $confId)
            ->limit(1)
            ->get(['id', 'short_alias_name']);
    }

    // Testimonials
    $testimonials = DB::table('testimonials')
        ->where(['conference_id' => $id, 'status' => 1])
        ->orderBy('id', 'DESC')
        ->get(['id', 'testimonial_title', 'testimonial_desc', 'testimonial_image', 'sub_title']);

    $testimonialspeakers = DB::table('testimonialspeakersays')
        ->where('status', 1)
        ->orderBy('id', 'DESC')
        ->limit(1)
        ->get(['id', 'testimonial_title', 'testimonial_desc']);

    // Skeleton Schedule
    $skeletonschedule = collect();
    if ($conferenceInfo && $conferenceInfo->from_date && $conferenceInfo->to_date) {
        $from = Carbon::parse($conferenceInfo->from_date);
        $to = Carbon::parse($conferenceInfo->to_date);
        $period = CarbonPeriod::create($from, '1 day', $to);

        $dayCounter = 1;
        foreach ($period as $date) {
            $schDate = $date->format('Y-m-d');
            $speakersInfo = DB::table('c_skeleton_schedule')
                ->where([
                    'status' => 1,
                    'conference_id' => $id,
                    'sch_day' => $dayCounter
                ])
                ->orderBy('id', 'ASC')
                ->get(['sch_from_time', 'sch_to_time', 'content_title', 'content_desc']);

            $skeletonschedule->push([
                'day' => 'Day ' . $dayCounter,
                'schDate' => $schDate,
                'schId' => $dayCounter - 1,
                'speakersInfo' => $speakersInfo
            ]);

            $dayCounter++;
        }
    }

    // Schedule Content
    $schedulecontent = DB::table('c_skeleton_schedule_content')
        ->where(['status' => 1, 'conference_id' => $id])
        ->limit(1)
        ->get(['content']);

    // Support Journals
    $supportJournals = DB::table('c_support_journals')
        ->where(['status' => 1, 'conference_id' => $id])
        ->get();

    // Early Bird
    $earlyBird = DB::table('c_earlybird')
        ->where(['status' => 1, 'conference_id' => $id])
        ->get();

    // Return JSON
    return response()->json([
        'success' => true,
        'homepageData' => [
            'conferenceInfo' => $conferenceInfo,
            'banners' => $banners,
            'sessionTracks' => $sessionTracks,
            'quickLinks' => $quickLinks,
            'impDates' => $impDates,
            'aboutus' => $aboutus,
            'welcomeMessage' => $welcomeMessage,
            'ocmSpeakers' => $ocmSpeakers,
            'categoriesResult' => $categoriesResult,
            'groupedSpeakers' => $groupedSpeakers,
            'sponsors' => $sponsors,
            'mediaPartners' => $mediaPartners,
            'venueInfo' => $venueInfo,
            'globaltarget' => $globaltarget,
            'popcontentInfo' => $popcontentInfo,
            'fieldwise' => $fieldwise,
            'pastconferencerepports' => $pastConferenceReport,
            'homeprevArray' => $homeprevArray,
            'homeprevAllArrayonlyfour' => $homeprevAllArrayonlyfour,
            'conferenceVideos' => $conferenceVideos,
            'pastvideosInfoname' => $pastvideosInfoname,
            'testimonials' => $testimonials,
            'testimonialspeakers' => $testimonialspeakers,
            'skeletonschedule' => $skeletonschedule->values(),
            'schedulecontent' => $schedulecontent,
            'supportJournals' => $supportJournals,
            'earlyBird' => $earlyBird,
        ]
    ]);
}
}