<?php

namespace App\Http\Controllers\Api;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;

class ConferenceBookApiController extends Controller
{
    public function show($id)
    {
        // Get conference unique_id
        $conference = DB::table('conferences')->select('unique_id')->find($id);
        if (!$conference) {
            return response()->json([
                'success' => false,
                'message' => 'Conference not found'
            ], 404);
        }

        $uploadsBase = "https://scisynopsisconferences.com/uploads/conferences";

        // Current Programs (page_type = 4)
        $currentPrograms = DB::table('c_brouchers')
            ->where([
                'conference_id' => $id,
                'page_type' => 4,
                'status' => 1
            ])
            ->orderBy('id', 'ASC')
            ->get()
            ->map(function ($item) use ($uploadsBase, $conference) {
                $item->pdf_url = "{$uploadsBase}/{$conference->unique_id}/" . urlencode($item->brouchure_name);
                return $item;
            });

        // Previous Programs
        $previousProgramsRaw = DB::table('c_prev_cnf_programs')
            ->where([
                'conference_id' => $id,
                'status' => 1
            ])
            ->orderBy('conference_year', 'DESC')
            ->get();

        $cmsInfo = [];
        foreach ($previousProgramsRaw as $prev) {
            $prevConf = DB::table('conferences')->find($prev->previous_conference_id);
            $program = DB::table('c_brouchers')
                ->where([
                    'conference_id' => $prev->previous_conference_id,
                    'page_type' => 3, // Previous program
                    'status' => 1
                ])
                ->orderBy('id', 'DESC')
                ->first();

            if ($program && $prevConf) {
                $program->pdf_url = "{$uploadsBase}/{$prevConf->unique_id}/" . urlencode($program->brouchure_name);
            }

            $cmsInfo[] = [
                'id' => $prev->id,
                'previous_conference_id' => $prev->previous_conference_id,
                'conference_year' => $prev->conference_year,
                'prevConferenceInfo' => $prevConf,
                'programInfo' => $program,
            ];
        }

        // Meta Data
        $metaRecord = DB::table('c_meta_data')
            ->where([
                'conference_id' => $id,
                'page_type' => 5 // Conference Book
            ])
            ->first();

        return response()->json([
            'success' => true,
            'conferenceBookData' => [
                'currentPrograms' => $currentPrograms,
                'cmsInfo' => $cmsInfo
            ],
            'meta' => [
                'title' => $metaRecord->meta_title ?? 'Conference Book – Conference',
                'description' => $metaRecord->meta_description ?? 'Explore current and past conference programs.',
                'keywords' => $metaRecord->meta_keywords ?? 'conference book, programs, brochures'
            ]
        ]);
    }
}