<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Conference;
use Illuminate\Http\JsonResponse;

class VenueV1ApiController extends Controller
{
    public function show($id): JsonResponse
    {
        $conference = Conference::with([
            'venue',
            'venue1',
            'venueImages',
            'cityAttractions',
            'faqs' => fn($q) => $q->orderBy('id', 'ASC'),
            'VenueV1metaData'
        ])->find($id);

        if (!$conference) {
            return response()->json([
                'success' => false,
                'message' => 'Conference not found'
            ], 404);
        }

        $venueInfo = $conference->venue;
        $venueInfo1 = $conference->venue1;
        $venueImages = $conference->venueImages;
        $attractionsInfo = $conference->cityAttractions;
        $faqs = $conference->faqs;
        $letterUrl = $venueInfo?->letter_url; // auto-appended via accessor

        $meta = $conference->VenueV1metaData;

        return response()->json([
            'success' => true,
            'venueData' => [
                'venueInfo' => $venueInfo,
                'venueInfo1' => $venueInfo1,
                'venueImages' => $venueImages,
                'attractionsInfo' => $attractionsInfo,
                'faqs' => $faqs,
                'letterUrl' => $letterUrl
            ],
            'meta' => [
                'title' => $meta?->meta_title ?? 'Venue – Conference',
                'description' => $meta?->meta_description ?? 'Conference venue, address, map, and city attractions.',
                'keywords' => 'venue, address, map, attractions, conference'
            ]
        ]);
    }
}