<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Conference;
use Illuminate\Http\JsonResponse;

class SponsorshipThankYouApiController extends Controller
{
    public function show($id): JsonResponse
    {
        $conference = Conference::with([
            'sponsorshipBrochure',
            'SponsorshipThankYouMetaData'
        ])->find($id);

        if (!$conference) {
            return response()->json([
                'success' => false,
                'message' => 'Conference not found'
            ], 404);
        }

        $brochure = $conference->sponsorshipBrochure;
        $meta = $conference->SponsorshipThankYouMetaData;

        return response()->json([
            'success' => true,
            'sponsorshipThankYouData' => [
                'brochure' => $brochure,
                'brochureUrl' => $brochure->brochure_url // auto-appended via accessor
            ],
            'meta' => [
                'title' => $meta->meta_title ?? 'Thank You – Sponsorship Download',
                'description' => 'Thank you for downloading the sponsorship brochure.',
                'keywords' => 'thank you, sponsorship, download, brochure'
            ]
        ]);
    }
}