<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Conference;
use App\Models\Cspeaker;
use Illuminate\Http\JsonResponse;

class SpeakersListApiController extends Controller
{
    public function show($id): JsonResponse
    {
        $speaker_type = request('speaker_type', '2');

        // Map speaker_type to page_type and other values
        $config = $this->getSpeakerConfig($speaker_type);
       $conference = Conference::with([
    'banners' => function ($q) use ($config) {
        $q->where('page_type', $config['page_type'])
          ->where('status', 1)
          ->orderByDesc('id');
    },
    'SpeakersListmetaData' => function ($q) use ($config) {
        $q->where('page_type', $config['page_type']);
    }
])->find($id);


        if (!$conference) {
            return response()->json(['error' => 'Conference not found'], 404);
        }

        $metaRow = $conference->SpeakersListmetaData()->first();

        // Preload speakers with countries
        $speakers = Cspeaker::with('country')
            ->where([
                'conference_id' => $id,
                'speaker_type' => $speaker_type
            ])
            ->orderBy('orderpos', 'ASC')
            ->get();

        $cmsInfo = $speakers->map(function ($s) {
            return [
                'id' => $s->id,
                'alias_name' => $s->alias_name,
                'speaker_img' => $s->speaker_img_url, // auto-appended via accessor
                'speaker_name' => $s->speaker_name,
                'speaker_title' => $s->speaker_title,
                'affliation' => $s->affliation,
                'speaker_type' => $s->speaker_type,
                'countryInfo' => $s->country ? [['country_name' => $s->country->country_name]] : []
            ];
        })->values();

        return response()->json([
            'success' => true,
            'cntlrname' => $config['cntlrname'],
            'clmName' => $config['clmName'],
            'clmName1' => $config['clmName1'],
            'clmName2' => $config['clmName2'],
            'speaker_type' => $speaker_type,
            'cmsInfo' => $cmsInfo,
            'banners' => $conference->banners,
            'meta' => [
                'title' => $metaRow?->meta_title ?? $config['clmName'] . ' – Conference',
                'description' => $metaRow?->meta_description ?? $config['clmName'],
                'keywords' => $metaRow?->meta_keywords ?? $config['clmName']
            ],
            'conferenceInfo' => $conference ? [$conference] : []
        ]);
    }

    private function getSpeakerConfig($speaker_type)
    {
        return match ($speaker_type) {
            '5' => [
                'page_type' => 6,
                'clmName' => 'E-Poster Presentation',
                'clmName1' => 'E-Poster',
                'clmName2' => 'Presentation',
                'cntlrname' => 'e-poster-presentation'
            ],
            '2' => [
                'page_type' => 7,
                'clmName' => 'Keynote Speakers',
                'clmName1' => 'Keynote',
                'clmName2' => 'Speakers',
                'cntlrname' => 'keynote-speakers'
            ],
            '3' => [
                'page_type' => 15,
                'clmName' => 'Renowned Speakers',
                'clmName1' => 'Renowned',
                'clmName2' => 'Speakers',
                'cntlrname' => 'renowned-speakers'
            ],
            default => [
                'page_type' => 9,
                'clmName' => 'Poster Presentation',
                'clmName1' => 'Poster',
                'clmName2' => 'Presentation',
                'cntlrname' => 'poster-presentation'
            ]
        };
    }
}