<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Conference;
use App\Models\Cspeaker;
use Illuminate\Http\JsonResponse;

class ScientificCommitteeApiController extends Controller
{
    public function show($id): JsonResponse
    {
        $conference = Conference::with([
            'scientificCommitteeSpeakers.country',
            'previousSpeakersMapping.previousConference',
            'ScientificCommitteemetaData'
        ])->find($id);

        if (!$conference) {
            return response()->json([
                'success' => false,
                'message' => 'Conference not found'
            ], 404);
        }

        $currentSpeakers = $conference->scientificCommitteeSpeakers;

        $previousSpeakers = $conference->previousSpeakersMapping->map(function ($prev) {
            $prevConf = $prev->previousConference;
            if (!$prevConf) return null;

            $speakers = Cspeaker::with('country')
                ->where([
                    'conference_id' => $prev->previous_conference_id,
                    'speaker_type' => 1,
                    'status' => 1
                ])
                ->orderBy('orderpos', 'ASC')
                ->get()
                ->map(function ($s) use ($prevConf) {
                    return [
                        'id' => $s->id,
                        'speaker_name' => $s->speaker_name,
                        'affliation' => $s->affliation,
                        'country_name' => $s->country_name,
                        'alias_name' => $s->alias_name,
                        'photo_url' => $s->photo_url,
                        'profile_url' => "/{$prevConf->folder_name}/scientific-committee/{$s->alias_name}"
                    ];
                });

            return [
                'id' => $prev->id,
                'conference_name' => $prevConf->conference_name,
                'speakers' => $speakers
            ];
        })->filter()->values();

        $meta = $conference->ScientificCommitteemetaData;

        return response()->json([
            'success' => true,
            'scientificCommitteeData' => [
                'currentSpeakers' => $currentSpeakers,
                'previousSpeakers' => $previousSpeakers
            ],
            'meta' => [
                'title' => $meta->meta_title ?? 'Scientific Committee – Conference',
                'description' => $meta->meta_description ?? 'Meet the distinguished members of our scientific committee.',
                'keywords' => $meta->meta_keywords ?? 'scientific committee, speakers, conference'
            ]
        ]);
    }
}