<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Conference;
use App\Models\Brochure;
use Illuminate\Http\JsonResponse;

class ProgramScheduleApiController extends Controller
{
    public function show($id): JsonResponse
    {
        $conference = Conference::with([
            'brochures' => fn($q) => $q->where('page_type', 3)->where('status', 1)->orderBy('id'),
            'previousPrograms.previousConference',
            'ProgramSchedulemetaData'
        ])->find($id);

        if (!$conference) {
            return response()->json([
                'success' => false,
                'message' => 'Conference not found'
            ], 404);
        }

        $currentPrograms = $conference->brochures;

        $cmsInfo = $conference->previousPrograms->map(function ($prev) {
            $prevConf = $prev->previousConference;
            if (!$prevConf) return null;

            $program = Brochure::where([
                'conference_id' => $prev->previous_conference_id,
                'page_type' => 3,
                'status' => 1
            ])
            ->orderBy('id', 'DESC')
            ->first();

            return [
                'id' => $prev->id,
                'previous_conference_id' => $prev->previous_conference_id,
                'conference_year' => $prev->conference_year,
                'prevConferenceInfo' => $prevConf,
                'programInfo' => $program ? [
                    'brouchure_name' => $program->brouchure_name,
                    'pdf_url' => $program->pdf_url // auto-appended via accessor
                ] : null
            ];
        })->filter(); // Remove null values

        $meta = $conference->ProgramSchedulemetaData;

        return response()->json([
            'success' => true,
            'programScheduleData' => [
                'currentPrograms' => $currentPrograms,
                'cmsInfo' => $cmsInfo->values()
            ],
            'meta' => [
                'title' => $meta?->meta_title ?? 'Conference Program – ' . ($conference->short_name ?? 'Conference'),
                'description' => $meta?->meta_description ?? 'View the full conference program and schedule.',
                'keywords' => $meta?->meta_keywords ?? 'program, schedule, agenda, conference'
            ]
        ]);
    }
}