<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\Payment;
use App\Models\Registration;
use App\Models\Conference;
use App\Models\Order;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Log;

class PaymentController extends Controller
{
    public function success(Request $request): JsonResponse
    {
        $request->validate([
            'order_id' => 'required',
            'transaction_id' => 'required',
            'method' => 'required'
        ]);

        // Update or create payment record
        $payment = Payment::updateOrCreate(
            ['order_id' => $request->order_id],
            [
                'transaction_id' => $request->transaction_id,
                'method' => $request->method,
                'status' => 'success',
                'paid_at' => now()
            ]
        );

        // Get user & conference
        $registration = Registration::with('conference')->find($request->order_id);

        if (!$registration || !$registration->conference) {
            return response()->json(['error' => 'User or conference not found'], 404);
        }

        // Send email
        $subject = "Thank You for Registration for " . $registration->conference->short_name;

        Mail::raw("Dear {$registration->firstname},\n\nThank you for registering for {$registration->conference->conference_name}.\n\nTransaction ID: {$request->transaction_id}\n\nBest regards,\n{$registration->conference->short_name} Team", function ($message) use ($registration, $subject) {
            $message->to($registration->usr_email)
                    ->subject($subject);
        });

        return response()->json(['success' => true]);
    }

    public function paypalSuccess($conferenceId, Request $request)
    {
        $orderId = $request->input('item_number_1') ?? $request->input('invoice');
        $order = Order::where('order_id', $orderId)->first();

        if ($order) {
            $order->status = 'paid';
            $order->transaction_id = $request->input('txn_id') ?? $request->input('PayerID');
            $order->save();
        }

        return redirect('/payment-success?order_id=' . $orderId);
    }

    public function paypalCancel()
    {
        return view('payments.cancelled');
    }

    public function paypalIpn(Request $request): JsonResponse
    {
        Log::info('PayPal IPN', $request->all());
        // TODO: validate IPN message from PayPal
        return response('OK', 200);
    }
}