<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Enquiry;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;

class ContactController extends Controller
{
    public function store(Request $request): JsonResponse
    {
        $request->validate([
            'conttitle' => 'required|string|max:255',
            'contfristname' => 'required|string|max:255',
            'contlastname' => 'required|string|max:255',
            'contemail' => 'required|email|max:255',
            'contphone' => 'required|string|max:20',
            'contorg' => 'required|string|max:255',
            'contcountry' => 'required|string|max:100',
            'contmsg' => 'required|string',
            'conference_id' => 'required|integer|exists:conferences,id',
        ]);

        $contname = trim($request->input('contfristname') . ' ' . $request->input('contlastname'));

        $enquiry = Enquiry::create([
            'conference_id' => $request->conference_id,
            'contname' => $contname,
            'contemail' => $request->contemail,
            'contphone' => $request->contphone,
            'contorg' => $request->contorg,
            'contmsg' => $request->contmsg,
            'conttitle' => $request->conttitle,
            'contcountry' => $request->contcountry,
            'enq_type' => 1,
            'contactDate' => now(),
        ]);

        return response()->json([
            'message' => 'Thank you for contacting us, we will contact you soon.',
            'id' => $enquiry->id
        ], 201);
    }
}